#ifndef _ROUTINES_CPP
#define _ROUTINES_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "NSWFL.H"
#include "Entry.H"
#include "Init.H"
#include "WinService.H"
#include "Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char gsSessionLogDir[MAX_PATH];
char sExportFileTemp[MAX_PATH];
char gsPath[MAX_PATH];
char gsServerAddress[255];

char gsAuthKey[MAX_AUTH_LENGTH];
char gsAuthString[MAX_AUTH_LENGTH];

char gsSQLDataFiles[MAX_PATH]; // Relative to server.
char gsDefaultDBO[255];
char gsReplicationDB[255];

char gsCompanyName[64];
char gsCompanyPassword[64];

char gsSQLDriver[255];
char gsSQLPassword[255];
char gsSQLServer[255];
char gsSQLUserID[255];
char gsSQLDatabase[255];

bool gbShowSplashScreen = false;
bool gbKillApplication = false;
bool gbApplicationRunning = false;
bool gbConnectNow = false;

int giServerPort = 0;
int giPingTimeoutMS = 0;

DWORD gdwStartTime = 0;
DWORD gdwStopTime = 0;
DWORD gdwNextTime = 0;
DWORD gdwConnectInterval = 0;

DWORD Timer_Thread_ID = 0;

HANDLE Timer_Thread_Handle = NULL;

FILE *gfhSessionLog = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetRegistryValues(void)
{
	DWORD iSizeofString = 0;

	iSizeofString = sizeof(gsReplicationDB);
	memset(gsReplicationDB, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ReplicationDB", gsReplicationDB, iSizeofString))
        return false;

	iSizeofString = sizeof(gsDefaultDBO);
	memset(gsDefaultDBO, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "DefaultDBO", gsDefaultDBO, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLDataFiles);
	memset(gsSQLDataFiles, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDataFiles", gsSQLDataFiles, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSessionLogDir);
	memset(gsSessionLogDir, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SessionLogDir", gsSessionLogDir, iSizeofString))
        return false;
	
    iSizeofString = sizeof(gsServerAddress);
	memset(gsServerAddress, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ServerAddress", gsServerAddress, iSizeofString))
        return false;
	
    iSizeofString = sizeof(sExportFileTemp);
	memset(sExportFileTemp, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ExportFileTemp", sExportFileTemp, iSizeofString))
        return false;
	
    iSizeofString = sizeof(gsPath);
	memset(gsPath, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "Path", gsPath, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsAuthKey);
	memset(gsAuthKey, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthKey", gsAuthKey, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsAuthString);
	memset(gsAuthString, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthString", gsAuthString, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsCompanyName);
	memset(gsCompanyName, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "CompanyName", gsCompanyName, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsCompanyPassword);
	memset(gsCompanyPassword, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "CompanyPassword", gsCompanyPassword, iSizeofString))
        return false;
		
	iSizeofString = sizeof(gsSQLDriver);
	memset(gsSQLDriver, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDriver", gsSQLDriver, iSizeofString))
        return false;
		
	iSizeofString = sizeof(gsSQLPassword);
	memset(gsSQLPassword, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLPassword", gsSQLPassword, iSizeofString))
        return false;
		
	iSizeofString = sizeof(gsSQLServer);
	memset(gsSQLServer, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLServer", gsSQLServer, iSizeofString))
        return false;
		
	iSizeofString = sizeof(gsSQLUserID);
	memset(gsSQLUserID, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLUserID", gsSQLUserID, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsSQLDatabase);
	memset(gsSQLDatabase, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDatabase", gsSQLDatabase, iSizeofString))
        return false;
	
	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "PingTimeoutMS", (DWORD &)giPingTimeoutMS))
        return false;
	
	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ConnectInterval", gdwConnectInterval))
        return false;
	
	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ServerPort", (DWORD &)giServerPort))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ShowSplashScreen", (DWORD &)gbShowSplashScreen))
        return false;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SaveRegistryValues(void)
{
	Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ReplicationDB", gsReplicationDB);
	Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "DefaultDBO", gsDefaultDBO);
	Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDataFiles", gsSQLDataFiles);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SessionLogDir", gsSessionLogDir);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ServerAddress", gsServerAddress);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ExportFileTemp", sExportFileTemp);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "Path", gsPath);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthKey", gsAuthKey);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthString", gsAuthString);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "CompanyName", gsCompanyName);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "CompanyPassword", gsCompanyPassword);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDriver", gsSQLDriver);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLPassword", gsSQLPassword);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLServer", gsSQLServer);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLUserID", gsSQLUserID);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDatabase", gsSQLDatabase);
	
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "PingTimeoutMS", (DWORD)giPingTimeoutMS);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ConnectInterval", (DWORD)gdwConnectInterval);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ServerPort", (DWORD)giServerPort);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ShowSplashScreen", (DWORD)gbShowSplashScreen);

	return true;
}	

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OpenLogFile(void)
{
    char FullFileName[MAX_PATH];

    SYSTEMTIME ST;

    GetLocalTime(&ST);

    char DateTemp[64 + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, NULL, &ST, "MM-dd-yy", DateTemp,64);

    sprintf(FullFileName, "%s\\%s.txt", gsSessionLogDir, DateTemp);

    if( (gfhSessionLog = fopen(FullFileName, "ab")) == NULL)
        return false;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CloseLogFile(void)
{
	if(gfhSessionLog)
	{
		fclose(gfhSessionLog);
		return true;
	}
	else return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteSysLog(char *sMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];
	char lsTemp[MAX_STATUS_TEXT + (64 * 2) + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &ST, NULL, lsDate, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, lsTime, 64);

	sprintf(lsTemp, "(%s %s) [*] %s", lsDate, lsTime, sMessage);
	fprintf(gfhSessionLog, "%s\r\n", lsTemp);
    InsertListBoxItem(MDI.LogList_hWnd, lsTemp, -1);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteLog(int iClientId, char *sMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];
	char lsTemp[MAX_STATUS_TEXT + (64 * 2) + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &ST, NULL, lsDate, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, lsTime, 64);

	sprintf(lsTemp, "(%s %s) [%d] %s", lsDate, lsTime, iClientId, sMessage);
	fprintf(gfhSessionLog, "%s\r\n", lsTemp);
    InsertListBoxItem(MDI.LogList_hWnd, lsTemp, -1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool WaitOnApplicationToExit(void)
{
    gbKillApplication = true; // Tell application to exit

    if(gbIsMainDialogOpen)
    {
        EndDialog(MainDialog_hWnd, 0);
    }

    while(gbApplicationRunning) // Wait on application to exit
    {
        Sleep(1);
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *ResolveHost(char *xHostName, int AddressNum)
{
	char *IPAddress = NULL;
	struct hostent * Host;
	struct in_addr Address;
	Host = gethostbyname(xHostName);
	if(Host == NULL)return NULL;
	memcpy(&Address.s_addr,(*Host).h_addr_list[AddressNum],(*Host).h_length);
	IPAddress = inet_ntoa(Address);
	return IPAddress;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetIPAddress(char *InputAddr, char *OutAddr)
{
	bool ValidIP = true;

    if(inet_addr(InputAddr) == INADDR_NONE) ValidIP = false;
    if(strlen(InputAddr) < 7)               ValidIP = false;
    if(strlen(InputAddr) > 15)              ValidIP = false;

    
	if(ValidIP == false)
	{
		char *Resolved = ResolveHost(InputAddr, 0);
		if(Resolved == NULL)
		{
			return false;
		}
		strcpy(OutAddr, Resolved); 
	}
	else{
		strcpy(OutAddr, InputAddr); 
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CalculateNextConnectTime(void)
{
	DWORD dwCurrentTime = 0;

	SYSTEMTIME ST;
	GetLocalTime(&ST);

	dwCurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);

	//Keep incrementing next connect time until it is greater than the current time.
	while(gdwNextTime < dwCurrentTime)
	{
		gdwNextTime = (gdwNextTime + (gdwConnectInterval * 60));
	}

	//Is the new 'next connect time' outside the window?
	if(dwCurrentTime <= gdwStartTime || dwCurrentTime >= gdwStopTime)
	{
		gdwNextTime = gdwStartTime;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void PrintNextRunTime(void)
{
    int iHour, iMinute, iSecond;

	SYSTEMTIME ST;
	char sNextTime[64];
	char sMessage[255];

	GetLocalTime(&ST);

	LongToTime(gdwNextTime, &iHour, &iMinute, &iSecond);

	ST.wHour   = iHour;
    ST.wMinute = iMinute;
    ST.wSecond = iSecond;

	GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, sNextTime, 64);

	sprintf(sMessage, "Next transfer will occur at: %s", sNextTime);
	WriteSysLog(sMessage);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Timer_Thread(LPVOID data)
{
	DWORD dwCurrentTime = 0;
	DWORD dwStatusTime = 0;
	SYSTEMTIME ST;

	gdwStartTime = TimeToLong(9, 0, 0);
	gdwStopTime = TimeToLong(17, 0, 0);

	gdwConnectInterval = 5;

	//GetSystemTime(&ST);
	GetLocalTime(&ST);

	dwCurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);

	//Set the next connect time to the beginning of the time window.
	gdwNextTime = gdwStartTime;

	CalculateNextConnectTime();

	while(!gbKillApplication)
	{
		//GetSystemTime(&ST);
		GetLocalTime(&ST);

		dwCurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);

		//Are we within the time window?
		if((dwCurrentTime >= gdwStartTime && dwCurrentTime <= gdwStopTime) || gbConnectNow)
		{
			//Is it time to connect?
			if(dwCurrentTime >= gdwNextTime || gbConnectNow)
			{
				if(ConnectToServer())
				{
					while(gServer.bcConnected[CCI.iThisClient])
					{
						Sleep(1);
					}
					Sleep(1000);
				}

				if(!gbConnectNow)
				{
					gdwNextTime = (gdwNextTime + (gdwConnectInterval * 60));
				}
				
				CalculateNextConnectTime();
				
				gbConnectNow = false;
			}
		}
		else gdwNextTime = gdwStartTime;

		//If the 'next connect time' has changed, log it.
		if(dwStatusTime != gdwNextTime)
		{
			PrintNextRunTime();
			dwStatusTime = gdwNextTime;
		}

		Sleep(1000);
	}

	/*
	while(!gbKillApplication)
    {
        DWORD TimeCount = 0;

        while((TimeCount < (gdwConnectInterval * 60)) && !gbConnectNow)
        {
            Sleep(1000);
            TimeCount++;
        }

        gbConnectNow = false;

        if(ConnectToServer())
		{
			while(gServer.bcConnected[CCI.iThisClient])
			{
				Sleep(1);
			}
		}
	}
	*/

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ConnectToServer(void)
{
	char IPAddress[64];
	
	if(gServer.bcConnected[CCI.iThisClient])
	{
		WriteSysLog("Already connected.");
		return false;
	}

	if(!GetIPAddress(gsServerAddress, IPAddress))
    {
        WriteSysLog("Error resolving hostname.");
        return false;
    }

	if(gServer.DoConnect(IPAddress, giServerPort, &CCI.iThisClient))
	{
		WriteLog(gServer.icClientID[CCI.iThisClient], "Connected successfully.");
	}
	else{
		WriteSysLog("Failed to connect.");

		if(gServer.bcConnected[CCI.iThisClient])
		{
			WriteLog(gServer.icClientID[CCI.iThisClient], "Dropping a possible locked connection.");
			gServer.bcDisconnect[CCI.iThisClient] = true;
			return false;
		}

		return false;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CmdCmp(const char *sBuf, const char *sCmd)
{
	int iCmdLen = strlen(sCmd);
	if( strncmp(sBuf, sCmd, iCmdLen) == 0)
		return iCmdLen;
	else return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AppendDataToCmd(const char *sCmd, char *sData, int iDataSz, char *sOutBuf)
{
	int iRPos = 0;
	int iRWos = strlen(sCmd);

	strcpy(sOutBuf, sCmd);

	while(iRPos < iDataSz)
		sOutBuf[iRWos++] = sData[iRPos++];

	return iRWos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int BreakCmdFromData(const char *sBuf, int iCmdLen, int iBufSz, char *sOutBuf)
{
	int WPos = 0;
	int RPos = iCmdLen;

	while(RPos < iBufSz)
		sOutBuf[WPos++] = sBuf[RPos++];

	sOutBuf[WPos] = '\0';

	return WPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
